<?php

/*
  Plugin Name: Admin Custom Setup
*/

define('EMPTY_TRASH_DAYS', 0 );
define('AUTOSAVE_INTERVAL', 300);
define('WP_POST_REVISIONS', false);

if (is_admin()) {
  function remove_admin_bar_links() {
    global $wp_admin_bar;

    $wp_admin_bar->remove_menu('wp-logo');
    $wp_admin_bar->remove_menu('comments');
    $wp_admin_bar->remove_menu('new-user');
  }
  add_action('wp_before_admin_bar_render', 'remove_admin_bar_links');

  function remove_admin_sidebar_links() {
    $current_user = wp_get_current_user();

    if ($current_user->user_login != 'studio') {
      remove_menu_page('tools.php');
      remove_menu_page('edit-comments.php');
      // remove_menu_page('edit-tags.php');
      remove_menu_page('plugins.php');
      remove_menu_page('users.php');
      remove_menu_page('options-general.php');
      remove_menu_page('theme-editor.php');
      remove_menu_page('yit_plugin_panel');
      remove_menu_page('theme_my_login');
      remove_menu_page('pmxi-admin-import');
    }
  }
  add_action('admin_menu', 'remove_admin_sidebar_links');

  function remove_admin_submenu_links() {
    $current_user = wp_get_current_user();

    if ($current_user->user_login != 'studio') {
      remove_submenu_page('themes.php', 'themes.php');
      remove_submenu_page('themes.php', 'theme-editor.php');
      remove_submenu_page('themes.php', 'theme_options');
      remove_submenu_page('themes.php', 'install-required-plugins');
    }
  }
  add_action('admin_init', 'remove_admin_submenu_links');

  function redirect_admin_removed_modules() {
    global $pagenow;

    $current_user = wp_get_current_user();
    $removedModules = array('edit-comments.php',
                            'tools.php',
                            'users.php',
                            'theme-editor.php',
                            'plugins.php',
                            'options-general.php');

    if (in_array($pagenow, $removedModules) && $current_user->user_login != 'studio') {
      wp_redirect(admin_url());
      exit;
    }
  }
  add_action('admin_init', 'redirect_admin_removed_modules');

  function remove_meta_boxes() {
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');
    remove_meta_box('dashboard_plugins', 'dashboard', 'normal');
    remove_meta_box('dashboard_primary', 'dashboard', 'normal');
    remove_meta_box('dashboard_secondary', 'dashboard', 'normal');
    remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');
    remove_meta_box('dashboard_recent_drafts', 'dashboard', 'side');
    remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
    remove_meta_box('ci_dashboard_widget_igniter_news', 'dashboard', 'normal');

    remove_meta_box('categorydiv', 'post', 'side');
    remove_meta_box('tagsdiv-post_tag', 'post', 'side');

    remove_meta_box('linktargetdiv', 'link', 'normal');
    remove_meta_box('linkxfndiv', 'link', 'normal');
    remove_meta_box('linkadvanceddiv', 'link', 'normal');
    remove_meta_box('trackbacksdiv', 'post', 'normal');
    remove_meta_box('postcustom', 'post', 'normal');
    remove_meta_box('commentstatusdiv', 'post', 'normal');
    remove_meta_box('commentsdiv', 'post', 'normal');
    remove_meta_box('revisionsdiv', 'post', 'normal');
    remove_meta_box('authordiv', 'post', 'normal');
    remove_meta_box('sqpt-meta-tags', 'post', 'normal');
  }
  add_action('admin_init', 'remove_meta_boxes');

  function remove_core_updates() {
    global $wp_version;

    if ($current_user->user_login != 'studio') {
      return(object) array('last_checked'=> time(),'version_checked'=> $wp_version);
    }
  }
  add_filter('pre_site_transient_update_core','remove_core_updates');
  add_filter('pre_site_transient_update_plugins','remove_core_updates');
  add_filter('pre_site_transient_update_themes','remove_core_updates');
}
