<?php
  
class WPML_Translation_Management{
    
    function __construct(){
        add_action('init', array($this,'init'));           
    }
    
    function __destruct(){
        
    }
    
    function init(){

	      global $sitepress;

        $this->plugin_localization();
        
        // Check if WPML is active. If not display warning message and not load Sticky links
        if(!defined('ICL_SITEPRESS_VERSION') || ICL_PLUGIN_INACTIVE){
            if ( !function_exists('is_multisite') || !is_multisite() ) {
                add_action('admin_notices', array($this, '_no_wpml_warning'));
            }
            return false;
        } elseif (!$sitepress->get_setting( 'setup_complete' )){
	        add_action('admin_notices', array($this, '_wpml_not_installed_warning'));
	        return false;
        }elseif(version_compare(ICL_SITEPRESS_VERSION, '2.0.5', '<')){
            add_action('admin_notices', array($this, '_old_wpml_warning'));
            return false;            
        }        
        
        if(is_admin()){        
           // add_filter('icl_menu_main_page', array($this, '_icl_menu_main_page'));
            add_action('icl_wpml_top_menu_added', array($this, '_icl_hook_top_menu'));        
            add_action('admin_menu', array($this,'menu'));               
            add_action('admin_menu', array($this,'menu_fix_order'), 999); // force 'Translations' at the end
            
            add_filter('plugin_action_links', array($this, 'plugin_action_links'), 10, 2); 
            
            if(!defined('DOING_AJAX')){
                wp_enqueue_script('wpml-tm-scripts', WPML_TM_URL . '/res/js/scripts.js', array('jquery'), WPML_TM_VERSION);
                wp_enqueue_style('wpml-tm-styles', WPML_TM_URL . '/res/css/style.css', array(), WPML_TM_VERSION); 
                wp_enqueue_style('wpml-tm-queue', WPML_TM_URL . '/res/css/translations-queue.css', array(), WPML_TM_VERSION); 
            }
            
            add_action( 'admin_print_footer_scripts', array($this, 'wp_tiny_mce_preload_dialogs'), 30 );
            
        
            add_action('icl_dashboard_widget_content_top', array($this, 'icl_dashboard_widget_content'));    
            
            add_action('icl_post_languages_options_before', array($this, 'icl_post_languages_options_before'));
            
            // Add a nice warning message if the user tries to edit a post manually and it's actually in the process of being translated
            global $pagenow;
            $request_get_trid = filter_input ( INPUT_GET, 'trid' );
            $request_get_post = filter_input ( INPUT_GET, 'post' );
            $request_get_lang = filter_input ( INPUT_GET, 'lang' );
            if ( ( $pagenow === 'post-new.php' || $pagenow === 'post.php' ) && ( $request_get_trid || $request_get_post ) && $request_get_lang ) {
                add_action ( 'admin_notices', array( $this, '_warn_editing_icl_translation' ) );
            }
            
            add_action('wp_ajax_dismiss_icl_side_by_site', array($this, 'dismiss_icl_side_by_site'));
            add_action('wp_ajax_icl_tm_parent_filter', array($this, '_icl_tm_parent_filter'));
            add_action('wp_ajax_icl_tm_toggle_promo', array($this, '_icl_tm_toggle_promo'));
            add_action('wp_ajax_icl_get_job_original_field_content', 'icl_get_job_original_field_content');
            
            add_action('admin_footer', array($this, '_icl_nonce_for_ajx'));
        }        

		return true;
    }
    
    function _no_wpml_warning(){
        ?>
        <div class="message error"><p><?php printf(__('WPML Translation Management is enabled but not effective. It requires <a href="%s">WPML</a> in order to work.', 'wpml-translation-management'), 
            'https://wpml.org/'); ?></p></div>
        <?php
    }
		function _wpml_not_installed_warning(){
			?>
			<div class="message error"><p><?php printf(__('WPML Translation Management is enabled but not effective. Please finish the installation of WPML first.', 'wpml-translation-management') ); ?></p></div>
		<?php
		}
    
    function _old_wpml_warning(){
        ?>
        <div class="message error"><p><?php printf(__('WPML Translation Management is enabled but not effective. It is not compatible with  <a href="%s">WPML</a> versions prior 2.0.5.', 'wpml-translation-management'), 
            'https://wpml.org/'); ?></p></div>
        <?php
    }    
    
    function _icl_menu_main_page($page){
        return basename(WPML_TM_PATH) . '/menu/main.php';
    }
    
    function _icl_hook_top_menu(){
	    if(!defined('ICL_PLUGIN_PATH')) return;
    	$top_page = apply_filters('icl_menu_main_page', basename(ICL_PLUGIN_PATH).'/menu/languages.php');
        add_submenu_page($top_page, 
            __('Translation Management','wpml-translation-management'), 
            __('Translation Management','wpml-translation-management'),
            'wpml_manage_translation_management', basename(WPML_TM_PATH) . '/menu/main.php');
    }
    
    function menu(){
	    if(!defined('ICL_PLUGIN_PATH')) return;
        global $sitepress, $iclTranslationManagement;
        
        if ($iclTranslationManagement && method_exists($sitepress, 'setup') && $sitepress->setup() && 1 < count($sitepress->get_active_languages())) {
            
            $current_translator = $iclTranslationManagement->get_current_translator();
            if(!empty($current_translator->language_pairs) || current_user_can('wpml_manage_translation_management')){
                if(current_user_can('wpml_manage_translation_management')){
                    $top_page = apply_filters('icl_menu_main_page', basename(ICL_PLUGIN_PATH).'/menu/languages.php');
                    add_submenu_page($top_page, 
                    __('Translations','wpml-translation-management'), __('Translations','wpml-translation-management'),
                    'wpml_manage_translation_management', WPML_TM_FOLDER.'/menu/translations-queue.php');
                } else {
                    add_menu_page(__('Translation interface','wpml-translation-management'), 
                        __('Translation interface','wpml-translation-management'), 'translate', 
                        WPML_TM_FOLDER.'/menu/translations-queue.php',null, ICL_PLUGIN_URL . '/res/img/icon16.png');
                }
            }
        }
                    
    }
    
    function menu_fix_order(){
        global $submenu;
        
        if(!isset($submenu[WPML_TM_FOLDER . '/menu/main.php'])) return;
        
        // Make sure 'Translations' stays at the end        
        $found = false;
        foreach($submenu[WPML_TM_FOLDER . '/menu/main.php'] as $id => $sm){            
            if($sm[2] == WPML_TM_FOLDER . '/menu/translations-queue.php'){
                $found = $sm;
                unset($submenu[WPML_TM_FOLDER . '/menu/main.php'][$id]);
                break;
            }                
        }
        if($found){
            $submenu[WPML_TM_FOLDER . '/menu/main.php'][] = $found;
        }
    }
  
    function _warn_editing_icl_translation(){
        global $wpdb, $sitepress, $iclTranslationManagement;
        $request_get_trid = filter_input(INPUT_GET, 'trid', FILTER_SANITIZE_NUMBER_INT, FILTER_NULL_ON_FAILURE);
        $request_get_post = filter_input(INPUT_GET, 'post', FILTER_SANITIZE_NUMBER_INT, FILTER_NULL_ON_FAILURE);
        $request_get_lang = filter_input(INPUT_GET, 'lang', FILTER_SANITIZE_FULL_SPECIAL_CHARS, FILTER_NULL_ON_FAILURE);

		$post_type = false;
        if($request_get_trid){
            $translation_id = $wpdb->get_var($wpdb->prepare("
                    SELECT t.translation_id 
                        FROM {$wpdb->prefix}icl_translations t
                        JOIN {$wpdb->prefix}icl_translation_status s ON t.translation_id = s.translation_id
                        WHERE t.trid=%d AND t.language_code=%s"
                , $request_get_trid, $request_get_lang));            
        }else{
            $post_type = $wpdb->get_var($wpdb->prepare("SELECT post_type FROM {$wpdb->posts} WHERE ID=%d", $request_get_post));
            $translation_id = $wpdb->get_var($wpdb->prepare("
                    SELECT translation_id FROM {$wpdb->prefix}icl_translations WHERE element_id=%d AND element_type=%s AND language_code=%s"
                , $request_get_post, 'post_' . $post_type, $request_get_lang));            
        }
        
        if($translation_id){
            $translation_status = $wpdb->get_var($wpdb->prepare("
                SELECT status FROM {$wpdb->prefix}icl_translation_status WHERE translation_id=%d"
            , $translation_id));  
            if(!is_null($translation_status) && $translation_status > 0 && $translation_status != ICL_TM_DUPLICATE && $translation_status < ICL_TM_COMPLETE){
                echo '<div class="error fade"><p id="icl_side_by_site">'. 
                    sprintf(__('<strong>Warning:</strong> You are trying to edit a translation that is currently in the process of being added using WPML.' , 'wpml-translation-management')) . '<br /><br />'.
                    sprintf(__('Please refer to the <a href="%s">Translation management dashboard</a> for the exact status of this translation.' , 'wpml-translation-management'),
                    admin_url('admin.php?page='.WPML_TM_FOLDER.'/menu/main.php&')) . '</p></div>';    
            }else{
				$is_original = false;
				if($post_type) {
					$element_language_details = $sitepress->get_element_language_details($request_get_post, 'post_' . $post_type);
					$is_original = !$element_language_details->source_language_code;
				}
                if(!$is_original && $iclTranslationManagement->settings['doc_translation_method'] == ICL_TM_TMETHOD_EDITOR){
                ?>
                <div class="error">
                    <p><?php _e('<strong>Warning:</strong> You are trying to edit a translation using the standard WordPress editor but your site is configured to use the WPML Translation Editor.' , 'wpml-translation-management')?></p>
                </div>
                <?php
                }
            }
        }elseif(($post_type && $sitepress->is_translated_post_type($post_type)) && $iclTranslationManagement->settings['doc_translation_method'] == ICL_TM_TMETHOD_EDITOR){
            ?>
            <div class="error">
                <p><?php _e('<strong>Warning:</strong> You are trying to add a translation using the standard WordPress editor but your site is configured to use the WPML Translation Editor.' , 'wpml-translation-management')?></p>
                <p><?php printf(__('You should use <a href="%s">Translation management dashboard</a> to send the original document to translation.' , 'wpml-translation-management'), admin_url('admin.php?page='.WPML_TM_FOLDER.'/menu/main.php')); ?>
                </p>
            </div>
            <?php
        }
        
    }
        
    function dismiss_icl_side_by_site(){
        global $iclTranslationManagement;
        $iclTranslationManagement->settings['doc_translation_method'] = ICL_TM_TMETHOD_MANUAL;
        $iclTranslationManagement->save_settings();
        exit;        
    }
        
    function icl_dashboard_widget_content(){
        global $wpdb, $ICL_Pro_Translation, $sitepress_settings, $sitepress, $current_user;
        get_currentuserinfo();
        $docs_sent = 0;
        $docs_completed = 0;
        $docs_waiting = 0;
        $docs_statuses = $wpdb->get_results($wpdb->prepare("SELECT status FROM {$wpdb->prefix}icl_translation_status WHERE status > %d", ICL_TM_NOT_TRANSLATED));
        foreach ($docs_statuses as $doc_status) {
            $docs_sent += 1;
            if ($doc_status->status == ICL_TM_COMPLETE) {
                $docs_completed += 1;
            } elseif ($doc_status->status == ICL_TM_WAITING_FOR_TRANSLATOR
                    || $doc_status->status == ICL_TM_IN_PROGRESS) {
                $docs_waiting += 1;
            }
        }        
        include WPML_TM_PATH . '/menu/_icl_dashboard_widget.php';
    }
    
    function icl_post_languages_options_before(){
        global $sitepress_settings, $icl_meta_box_globals, $iclTranslationManagement, $sitepress, $post;
        
        // Get them from Sitepress::meta_box
        extract($icl_meta_box_globals);

		/** @var $translations array        coming from $icl_meta_box_globals */
		/** @var $active_languages array    coming from $icl_meta_box_globals */
		/** @var $selected_language string  coming from $icl_meta_box_globals */

		$translations_count = count($translations) - 1;

		$language_count = count($active_languages) - 1;

        // get languages with translators
        $languages_translated = $languages_not_translated = array();
        
        if(!empty($sitepress_settings['icl_lang_status']))
        foreach($sitepress_settings['icl_lang_status'] as $k=>$language_pair){
            if(!is_numeric($k)) continue;
            if($language_pair['from'] == $selected_language && !empty($language_pair['translators'])){
                $languages_translated[] = $language_pair['to'];
                $lang_rates[$language_pair['to']] = $language_pair['max_rate'];
            }
        }
		$languages_not_translated = array_diff(array_keys($active_languages), array_merge(array($selected_language), $languages_translated));
        
        // get pro translations        
        $pro_translations = $iclTranslationManagement->get_element_translations($post->ID, 'post_'.$post->post_type);            
        
        include WPML_TM_PATH . '/menu/_icl_post_menu.php';
    }
    
    function plugin_action_links($links, $file){
        $this_plugin = basename(WPML_TM_PATH) . '/plugin.php';
        if($file == $this_plugin) {
            $links[] = '<a href="admin.php?page='.basename(WPML_TM_PATH) . '/menu/main.php">' . 
                __('Configure', 'wpml-translation-management') . '</a>';
        }
        return $links;
    }

    // Localization
    function plugin_localization(){
        load_plugin_textdomain( 'wpml-translation-management', false, WPML_TM_FOLDER . '/locale');
    }
 
    function wp_tiny_mce_preload_dialogs() {
        // It's not clear why we need this function
        // It was there to fix a javascript error with a plugin
        // Can't remember which plugin.
        // wp_tiny_mce_preload_dialogs is no longer available in WP 3.2 so we need to check for it.
 
        if (isset($_GET['page']) && $_GET['page'] == WPML_TM_FOLDER.'/menu/translations-queue.php' && function_exists('wp_tiny_mce_preload_dialogs')) {
            wp_tiny_mce_preload_dialogs();
        }
    }
    
    //
    function _icl_tm_parent_filter(){
        global $sitepress;
		$current_language = $sitepress->get_current_language();
		$request_post_type = filter_input(INPUT_POST, 'type', FILTER_SANITIZE_FULL_SPECIAL_CHARS, FILTER_NULL_ON_FAILURE);
		$request_post_lang = filter_input(INPUT_POST, 'lang', FILTER_SANITIZE_FULL_SPECIAL_CHARS, FILTER_NULL_ON_FAILURE);
		$request_post_parent_id = filter_input(INPUT_POST, 'parent_id', FILTER_SANITIZE_NUMBER_INT, FILTER_NULL_ON_FAILURE);
		$request_post_parent_all = filter_input(INPUT_POST, 'parent_all', FILTER_SANITIZE_FULL_SPECIAL_CHARS, FILTER_NULL_ON_FAILURE);
		$sitepress->switch_lang($request_post_lang);
        if($request_post_type == 'page'){                        
            $html = wp_dropdown_pages(array('echo'=>0, 'name'=>'filter[parent_id]', 'selected'=>$request_post_parent_id));            
        }elseif($request_post_type == 'category'){
            $html = wp_dropdown_categories(array('echo'=>0, 'orderby'=>'name', 'name'=>'filter[parent_id]', 'selected'=>$request_post_parent_id));
        }else{
            $html = '';
        }
        $sitepress->switch_lang($current_language);
        
        $html .= "<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				if(is_null($request_post_parent_all) || $request_post_parent_all) { 
					$checked = ' checked="checked"'; 
				} else {
					$checked="";
				}
        $html .= "<label><input type=\"radio\" name=\"filter[parent_all]\" value=\"1\" {$checked} />&nbsp;" . __('Show all items under this parent.', 'wpml-translation-management') . '</label>';
        $html .= "<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if(empty($request_post_parent_all)) {
					$checked = ' checked="checked"'; 
				} else {
					$checked="";
				}
        $html .= "<label><input type=\"radio\" name=\"filter[parent_all]\" value=\"0\" {$checked} />&nbsp;" . __('Show only items that are immediately under this parent.', 'wpml-translation-management') . '</label>';
        
        echo json_encode(array('html'=>$html));
        exit;
        
    }
    
    function _icl_tm_toggle_promo(){
        global $sitepress;
        $iclsettings['dashboard']['hide_icl_promo'] = @intval($_POST['value']);
        $sitepress->save_settings($iclsettings);
        exit;
    }
    
    function _icl_nonce_for_ajx(){
		global $pagenow;

		//@since 3.1	Calls made only when in Translation Management pages
		$allowed_pages = array();
		if(defined('WPML_TM_FOLDER')) {
			$allowed_pages[] = WPML_TM_FOLDER . '/menu/main.php';
		}

		if(!isset($_REQUEST['page']) || !in_array($_REQUEST['page'], $allowed_pages)) {
			return;
		}

        wp_nonce_field('get_translator_status_nonce', '_icl_nonce_gts');
    }
   
}
