<?php if ( has_post_thumbnail() ) : ?>
	<figure class="entry-image">
		<?php
			$url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large', true );
			echo '<a href="'. $url[0] .'" class="thumb" rel="fancybox['. $post->ID .']" title="">'.get_the_post_thumbnail($post->ID, 'ci_listing_thumb').'</a>';
		?>
	</figure>
<?php endif; ?>

<div class="entry-content group">
	<?php
		$linkurl = get_post_meta($post->ID, 'ci_format_link_url', true);
		$nofollow = get_post_meta($post->ID, 'ci_format_link_nofollow', true);
		$nofollow = $nofollow=='nofollow' ? 'rel="nofollow"' : '';
	?>

	<p><a href="<?php echo esc_url($linkurl); ?>" <?php echo $nofollow; ?> title="<?php echo esc_attr(sprintf(__('External link to: %s', 'ci_theme'), get_the_title())); ?>"><?php _e('Visit the link', 'ci_theme'); ?></a></p>

	<?php ci_e_content(); ?>
</div>
