<?php global $ci, $ci_defaults, $load_defaults, $content_width; ?>
<?php if ($load_defaults===TRUE): ?>
<?php
	add_filter('ci_panel_tabs', 'ci_add_tab_display_options', 40);
	if( !function_exists('ci_add_tab_display_options') ):
		function ci_add_tab_display_options($tabs) 
		{ 
			$tabs[sanitize_key(basename(__FILE__, '.php'))] = __('Display Options', 'ci_theme'); 
			return $tabs; 
		}
	endif;
	
	// Default values for options go here.
	// $ci_defaults['option_name'] = 'default_value';
	// or
	// load_panel_snippet( 'snippet_name' );

	$ci_defaults['image_linkage']= 'enabled';
	
	$ci_defaults['show_author_info']= 'enabled';

	$ci_defaults['fixed_footer']= '';

	$ci_defaults['disable_infinitescroll']= '';

	load_panel_snippet('pagination');
	load_panel_snippet('excerpt');
	load_panel_snippet('seo');
	load_panel_snippet('comments');

	load_panel_snippet('slider_flexslider');

	load_panel_snippet('featured_image_single');


	// Set our full width template width and options.
	add_filter('ci_full_template_width', 'ci_fullwidth_width');
	if( !function_exists('ci_fullwidth_width') ):
	function ci_fullwidth_width()
	{ 
		return 1020; 
	}
	endif;
	load_panel_snippet('featured_image_fullwidth');

	add_filter('body_class','ci_footer_fixed_class');
	if( !function_exists('ci_footer_fixed_class')):
	function ci_footer_fixed_class($classes) {
		$footerclasses = array();
		if(ci_setting('fixed_footer')=='enabled')
		{
			$footerclasses['fixed_footer']='fixed-footer';
		}
		return array_merge($classes, $footerclasses);
	}	
	endif;
	
?>
<?php else: ?>

	<fieldset class="set">
		<legend>Featured Images</legend>
		<p class="guide"><?php _e('Disable this option if you want featured images to link to single posts instead of popping up a lightbox on homepage/archive pages.' , 'ci_theme'); ?></p>
		<?php ci_panel_checkbox('image_linkage', 'enabled', __('Enable featured image link to lightbox', 'ci_theme')); ?>
	</fieldset>

	<?php load_panel_snippet('slider_flexslider'); ?>

	<?php load_panel_snippet('pagination'); ?>	

	<?php load_panel_snippet('excerpt'); ?>	

	<?php load_panel_snippet('seo'); ?>	

	<?php load_panel_snippet('comments'); ?>	

	<fieldset class="set">
		<p class="guide"><?php _e('You can enable and disable the Author name below each post\'s title.' , 'ci_theme'); ?></p>
		<?php ci_panel_checkbox('show_author_info', 'enabled', __('Enable Author Name', 'ci_theme')); ?>
	</fieldset>

	<?php load_panel_snippet('featured_image_single'); ?>

	<?php load_panel_snippet('featured_image_fullwidth'); ?>
	
	<fieldset class="set">
		<p class="guide"><?php _e('You can disable infinite scrolling. Listing pages will not auto-load posts via AJAX and normal pagination will be enabled.' , 'ci_theme'); ?></p>
		<?php ci_panel_checkbox('disable_infinitescroll', 'enabled', __('Disable infinite scroll', 'ci_theme')); ?>
	</fieldset>

	<fieldset class="set">
		<p class="guide"><?php _e('You can make your footer fixed into place on the bottom of the screen. This is useful as sites with a lot of content that have infinite scroll <b>enabled</b> and may never have a chance to show their footer before the user leaves.' , 'ci_theme'); ?></p>
		<?php ci_panel_checkbox('fixed_footer', 'enabled', __('Enable fixed footer', 'ci_theme')); ?>
	</fieldset>
	

<?php endif; ?>