<!doctype html>
<!--[if lt IE 7]> <html <?php language_attributes(); ?> class="no-js lt-ie9 lt-ie8 lt-ie7" > <![endif]-->
<!--[if IE 7]>    <html <?php language_attributes(); ?> class="no-js ie7 lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>    <html <?php language_attributes(); ?> class="no-js ie8 lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html <?php language_attributes(); ?> class="no-js"> <!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">

	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

	<?php wp_head(); ?>

    <!-- slick slider -->
    <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
</head>

<?php
$alt_layout = ci_setting('layout')=='alt' ? ' alt ' : '';
?>
<body <?php body_class( $alt_layout ); ?>>
<?php do_action('after_open_body_tag'); ?>

<header id="header">
	<div class="pre-head show-on-mobile">
		<div class="wrap group">
			<div class="pre-head-wgt group">
				<?php dynamic_sidebar('top_bar'); ?>
			</div> <!-- .header-wgt -->
		</div>
	</div> <!-- .pre-head -->

	<div id="site-head">
		<div class="wrap group">
			<hgroup class="logo <?php echo ( ci_setting('logo')!='' ? 'imglogo' : 'textual' ); ?>">
				<?php ci_e_logo('<h1>', '</h1>'); ?>
			</hgroup>

			<div class="header-wgt group">
				<?php dynamic_sidebar('top_bar'); ?>
			</div> <!-- .header-wgt -->
		</div> <!-- .wrap < #header -->
	</div> <!-- #site-head -->

	<nav>
		<div class="wrap group">
			<?php
				if(has_nav_menu('ci_main_menu'))
					wp_nav_menu( array(
						'theme_location' 	=> 'ci_main_menu',
						'fallback_cb' 		=> '',
						'container' 		=> '',
						'menu_id' 			=> 'navigation',
						'menu_class' 		=> 'group'
					));
				else
					wp_page_menu(array('menu_class'=>'group'));
			?>
		</div> <!-- .wrap < nav -->
	</nav>
</header>

<?php get_template_part('inc_slider'); ?>

<section id="main">
	<div class="wrap group">