  <?php 
  
    $sld_q = new WP_Query( array(
        'post_type'      => array( 'cpt_slider', 'post' ),
        'meta_key'       => 'ci_post_slider',
        'meta_value'     => 'slider',
        'posts_per_page' => -1
    )); 
  
  ?>

  <?php if ( $sld_q->have_posts() ) : ?>
  <section id="slider">
    <div class="wrap group">
      <div class="home-slider">
        <div class="slides">
          <?php while ( $sld_q->have_posts() ) : $sld_q->the_post(); ?>
            <!-- slide -->
            <div class="slide">
                <?php
                $permalink = get_post_meta( get_the_ID(), 'ci_cpt_slider_url', true );
                ?>

                <?php if (empty($permalink)): ?>
                    <div style="display: flex; justify-content: center;">
                        <?php the_post_thumbnail('homepage_slider'); ?>
                    </div>
                    <?php else: ?>
                        <a href="<?php echo esc_url( $permalink ); ?>"><?php the_post_thumbnail('homepage_slider'); ?></a>
                <?php endif; ?>

                <?php if (!empty($post->post_content)): ?>
                    <div class="slide-content">
                        <?php if (empty($permalink)): ?>
                            <h2 class="slide-title"><?php the_title(); ?></h2>
                        <?php else: ?>
                            <h2 class="slide-title"><a href="<?php echo esc_url( $permalink ); ?>"><?php the_title(); ?></a></h2>
                        <?php endif ?>
                        <?php the_excerpt(); ?>
                    </div>
                <?php endif; ?>
            </div>
            <!-- slide end -->
          <?php endwhile; ?>
          <?php wp_reset_postdata(); ?>
        </div>
      </div>
    </div>
  </section>
  <?php endif; // endif slider have_posts() ?>


<!-- slick slider -->
<script type="text/javascript" src="//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>

<script>

jQuery(document).ready(function() {
    jQuery('.slides').slick({
            dots: false,
            infinite: true,
            autoplay: true,
            pauseOnHover: false,
            autoplaySpeed: 3000,
            slidesToShow: 1,
            prevArrow: false,
            nextArrow: false,
            fade: true
        });
    });

</script>