<?php get_header(); ?>

<div id="box-container">
	<div id="entry-listing" class="group">
		<?php
			global $paged;

			$max_page = (int) $wp_query->max_num_pages;
			if ( $max_page > (int) 1 )
				$paged = $wp_query->query_vars['paged']<=1 ? (int)1 : $wp_query->query_vars['paged'];

			// Show this widget area only on the first page and only if its populated with widgets
		?>

		<?php if ( $paged < 2 && is_active_sidebar('first-box')  ): ?>
			<article id="intro" class="entry box">
				<div class="entry-content-cnt">
					<?php dynamic_sidebar('first-box'); ?>
				</div>
			</article>
		<?php endif; ?>

		<?php if(have_posts()): ?>
			<?php while ( have_posts() ) : the_post(); ?>
	
				<?php
					$format = get_post_format($post->ID);
	
					if ( $format === false ) {
						$format = 'standard';
					}
				?>
				
				<article id="post-<?php the_ID();?>" <?php post_class('entry box format-'.$format); ?>>
	
					<?php get_template_part('index', $format); ?>
	
				</article>
	
			<?php endwhile; ?>

			<?php if(is_active_sidebar('last-box-repeat')): ?>
				<article class="entry box">
					<div class="entry-content-cnt">
						<?php dynamic_sidebar('last-box-repeat'); ?>
					</div>
				</article>
			<?php endif; ?>

		<?php endif; // have_posts() ?>

	</div> <!-- #entry-listing -->

	<?php if(ci_setting('disable_infinitescroll')!='enabled'): ?>
		<div class="ci_load_more">
			<?php next_posts_link( __( '&laquo; Next Set of Entries', 'ci_theme' ) ); ?>
		</div>
	<?php else: ?>
		<?php ci_pagination(); ?>
	<?php endif; ?>
</div>  <!-- #box-container -->

<?php get_footer(); ?>