jQuery(document).ready(function($) {
	$('body').fitVids();

	//
	// Flexslider
	//
	if( $(".flexslider").length > 0) {
		$(".flexslider").flexslider({
			'controlNav': true,
			'directionNav': true,
			'animation': ThemeOption.slider_effect,
			'slideDirection': ThemeOption.slider_direction,
			'slideshow': Boolean(ThemeOption.slider_autoslide),
			'slideshowSpeed': Number(ThemeOption.slider_speed),
			'animationDuration': Number(ThemeOption.slider_duration)
		});
	}

	if( $(".home-slider").length > 0) {
		$(".home-slider").flexslider({
			'controlNav': false,
			'directionNav': false,
			'animation': 'fade',
			'slideshowSpeed': 10000
		});
	}

	var $menu = $("#navigation");
	$menu.superfish({
		animation: {
			opacity: "show"
		},
		speed: "fast",
		delay: 250
	});

	$(".searchsubmit").bind("click", function() {
		$(this).parent().submit();
	});


	// Show the videos in a lightbox
	$("#main").on('click', "a[rel^='fancybox-video']", function(){
		var link = $(this).attr('href');
		$.fancybox.showLoading();
		$.get(link, function(data){
			data = $(data).find('.entry-image');
			$.fancybox.open(data, {
				fitToView: true
			});
		});
		return false;
	});

	// Responsive menu
	$("<select />").appendTo("nav");

	// Create default option "Go to..."
	$("<option />", {
		"selected": "selected",
		"value": "",
		"text": "Go to..."
	}).appendTo("nav select");

	// Populate dropdown with menu items
	$("nav a").each(function () {
		var el = $(this);
		$("<option />", {
			"value": el.attr("href"),
			"text": el.text()
		}).appendTo("nav select");
	});

	$("nav select").change(function () {
		window.location = $(this).find("option:selected").val();
	});

	$(function(){
		$.fn.formLabels();
	});
});

jQuery(window).load( function() {

	//Initialize Isotope
	jQuery('#entry-listing').isotope({
		animationOptions: {
			duration: 750,
			easing: 'linear',
			queue: false
		},
		itemSelector: 'article.entry',
		transformsEnabled: false
	});

	// Page width calculations
	jQuery(window).resize(setContainerWidth);
	var $box = jQuery(".box");

	function setContainerWidth() {
		var columnNumber = parseInt((jQuery(window).width()+15) / ($box.outerWidth(true))),
			containerWidth = (columnNumber * $box.outerWidth(true)) - 15;

		if ( columnNumber > 1 )  {
			jQuery("#box-container").css("width",containerWidth+'px');
		} else {
			jQuery("#box-container").css("width", "100%");
		}
	}

	setContainerWidth();
	loadAudioPlayer(ThemeOption.swfPath);

});


function loadAudioPlayer(domain) {
	jQuery(".format-audio").each(function() {
		var $audio_id = jQuery(this).find(".audio-wrap").data("audio-id"),
			$media = jQuery(this).find(".audio-wrap").data("audio-file"),
			$play_id = '#jp-'+$audio_id,
			$play_ancestor = '#jp-play-'+$audio_id,
			$extension = $media.split('.').pop();

		if ( $extension.toLowerCase() =='mp3' ) {
			$extension = 'mp3';
		} else if ( $extension.toLowerCase() =='mp4' ||  $extension.toLowerCase() =='m4a' ) {
			$extension = 'm4a';
		} else if ( $extension.toLowerCase() =='ogg' || $extension.toLowerCase() =='oga' ) {
			$extension = 'oga';
		} else {
			$extension = '';
		}


		jQuery($play_id).jPlayer({
			ready: function (event) {
				var playerOptions = {
						$extension: $media
					};
				playerOptions[$extension] = $media;
				jQuery(this).jPlayer("setMedia", playerOptions);
			},
			swfPath: domain,
			supplied: $extension,
			wmode: 'window',
			cssSelectorAncestor: $play_ancestor
		});

	});
}
