<?php get_header(); ?>

<div id="box-container">
	<div id="entry-listing" class="group">

		<?php
			global $wp_query;

			$found = $wp_query->found_posts;
			$none  = __( 'No results found. Please broaden your terms and search again.', 'ci_theme' );
			$one   = __( 'Just one result found. We either nailed it, or you might want to broaden your terms and search again.', 'ci_theme' );
			$many  = sprintf( _n( '%d result found.', '%d results found.', $found, 'ci_theme' ), $found );
		?>
		<?php
			global $paged;

			$max_page = (int) $wp_query->max_num_pages;
			if ( $max_page > (int) 1 )
				$paged = $wp_query->query_vars['paged']<=1 ? (int)1 : $wp_query->query_vars['paged'];

			// Show the search area only on the first page
		?>

		<?php if ( $paged < 2 ): ?>
			<article id="intro" class="entry box">
				<div class="entry-content-cnt">
					<h1><?php _e( 'Search Results', 'ci_theme' ); ?></h1>
					<p><?php ci_e_inflect($found, $none, $one, $many); ?></p>
					<?php if( $found==0 ) : ?>
						<?php get_search_form(); ?>
					<?php endif; ?>
				</div>
			</article>
		<?php endif; ?>

		<?php if(have_posts()): ?>
			<?php while ( have_posts() ) : the_post(); ?>
	
				<?php
					$format = get_post_format($post->ID);
	
					if ( $format === false ) {
						$format = 'standard';
					}
				?>
				
				<article id="post-<?php the_ID();?>" <?php post_class('entry box format-'.$format); ?>>
	
					<?php get_template_part('index', $format); ?>
	
				</article>
	
			<?php endwhile; ?>

			<?php if(is_active_sidebar('last-box-repeat')): ?>
				<article class="entry box">
					<div class="entry-content-cnt">
						<?php dynamic_sidebar('last-box-repeat'); ?>
					</div>
				</article>
			<?php endif; ?>

		<?php endif; // have_posts() ?>

	</div> <!-- #entry-listing -->

	<?php if(ci_setting('disable_infinitescroll')!='enabled'): ?>
		<div class="ci_load_more">
			<?php next_posts_link( __( '&laquo; Next Set of Entries', 'ci_theme' ) ); ?>
		</div>
	<?php else: ?>
		<?php ci_pagination(); ?>
	<?php endif; ?>
</div>  <!-- #box-container -->

<?php get_footer(); ?>