<?php get_header(); ?>

<?php
	the_post();

	$format = get_post_format($post->ID);

	if ( $format === false ) {
		$format = 'standard';
	}
?>

<div class="inner-container full group">

	<div class="box-hold group">
		<article id="post-<?php the_ID();?>" <?php post_class('entry box format-'.$format); ?>>

			<div class="entry-intro">
				<h1><?php the_title(); ?></h1>
				<span class="entry-meta">
					<?php
						if(ci_setting('show_author_info')=='enabled')
							echo sprintf(_x('Posted by <strong>%1$s</strong>, on %2$s', 'posted by author_name, on date', 'ci_theme'), get_the_author(), '<time datetime="' . esc_attr( get_the_date( 'c' ) ) . '">'.get_the_date().'</time>');
						else
							echo sprintf(_x('Posted on %s', 'posted on date', 'ci_theme'), '<time datetime="' . esc_attr( get_the_date( 'c' ) ) . '">'.get_the_date().'</time>');
					?>
				</span>
			</div> <!-- .entry-intro -->

			<?php get_template_part('format', $format); ?>

		</article>
	</div> <!-- .box-hold -->

</div> <!-- .inner-container -->

<?php get_footer(); ?>